
Projectile = inherited("Projectile", ActionEntity)

Network.registerClass(Projectile)

Projectile.variables = {
	sync = {"x", "y", "angle"},
	new = {"map", "owner", "x", "y", "angle", "dx", "dy", "da", "type"},
}
Projectile.structure = {
	sync = {"f","f","f"},
	new = {"e", "e", "f", "f","f","f","f", "f", "i"},
}


function Projectile:new(map, owner, x, y, angle, dx, dy, da, type)
	local b = instance(self, map, owner, x, y, angle, dx, dy, da, PROJECTILE_TYPES[type].health)
	b.type = type
	b.time = 0
	map:addEnt(b)
	return b
end

function Projectile:def()
	return PROJECTILE_TYPES[self.type]
end

function Projectile:getRadius()
	return self:stat("radius")
end

function Projectile:step(time)
	--anglespeed control
	self:applyFrictionDelta(time)
	self:applyFriction(time)
	self:applyAngleAdjustment(time)
	self:applyGravity(time)
	--gravity
	self.time = self.time + time
	if self.time > 5 then
		self:remove()
	end

	self:applyHail(time)
	self:super().step(self, time)
end

function Projectile:renderAt(x,y,scale,angle,a,r,g,b)
	if self:def().getRGB then
		r,g,b = self:def().getRGB(self, r, g, b)
	end
	video.renderSpriteState(self:def().sprites.main, x, y, scale, angle + self.angle, a, r, g ,b, true)
end

function Projectile:onCollided(normal, impulse)
	self.health = 0
end

function Projectile:getMass()
	return self:stat("mass")
end

function Projectile:onHit(ent, angle, impulse, counterImpulse)
	self.health = 0
	if ent:canBeHurtBy(self) then
		if ent:hurt(impulse*self:stat("impulseDamageFactor")) then
			ent:onKilled()
		end
	end
end	


